/**
 * Marker component renders an SVG icon that represents a marker.
 *
 * @return {JSX.Element} SVG component for a marker icon.
 */
function MarkerIcon() {
    return (
        <svg
            width="24px"
            height="24px"
            xmlns="http://www.w3.org/2000/svg"
            viewBox="-5.0 -10.0 110.0 135.0"
        >
            <path
                d="M90.492 24.562a8.787 8.787 0 01.285 12.125l-36.96 40.629a1.957 1.957 0 01-2.824.066L20.784 47.175a1.953 1.953 0 01.066-2.824l40.63-36.96a8.787 8.787 0 0112.124.284z"
                fillRule="evenodd"
            />
            <path
                d="M53.754 77.387l-5.418 5.418a4.886 4.886 0 01-6.035.691c-.004 0-.004-.003-.008-.003-2.914-1.832-5.793-2.614-8.66-2.188-2.946.438-5.84 2.121-8.739 5.004a1.953 1.953 0 01-2.757-.004l-10.27-10.27a1.953 1.953 0 01-.004-2.758c2.886-2.898 4.566-5.793 5.004-8.738.425-2.867-.356-5.75-2.188-8.66 0-.004-.004-.004-.004-.008a4.881 4.881 0 01.692-6.031c2.113-2.118 5.418-5.418 5.418-5.418.761-.762 2-.762 2.761 0l30.207 30.207c.762.761.762 2 0 2.761zm-4.14-1.379L22.167 48.563l-4.035 4.035a.97.97 0 00-.137 1.203c2.387 3.793 3.297 7.57 2.743 11.31-.473 3.18-2.024 6.359-4.77 9.495l7.602 7.602c3.14-2.746 6.32-4.297 9.496-4.77 3.738-.554 7.515.356 11.312 2.747a.976.976 0 001.203-.14l4.035-4.036z"
                fillRule="evenodd"
            />
            <path
                d="M4.867 84.551l9.14-9.14c.763-.762 2-.762 2.762 0l5.989 5.988c.762.761.762 2 0 2.761l-3.152 3.153c-.368.367-.864.57-1.38.57H6.25a1.957 1.957 0 01-1.383-3.336zM6.246 94.863a1.954 1.954 0 010-3.906H93.72a1.954 1.954 0 010 3.906z"
                fillRule="evenodd"
            />
        </svg>
    );
}

export default MarkerIcon;
